**************************************************************************************************
***************DO AUSTRALIANS BORROW TO KEEP UP WITH THEIR JONESES - SET UP***********************
*************************DATE: AUG 2022 **********************************************************
************************ AUTHOR: KIM NGUYEN ******************************************************
**************************************************************************************************

clear all
set more off
set maxvar 30000
set matsize 10000

//Load data
use "mydata\UnbalancedHH.dta", clear

*** Drop persons without household  population weight information
drop if hhwth<0|hhwth==.

**********************
***** Set panel ******
**********************
replace hhid0= subinstr(hhid0, "a", "2001",.) 
replace hhid0= subinstr(hhid0, "b", "2002",.) 
replace hhid0= subinstr(hhid0, "c", "2003",.) 
replace hhid0= subinstr(hhid0, "d", "2004",.) 
replace hhid0= subinstr(hhid0, "e", "2005",.) 
replace hhid0= subinstr(hhid0, "f", "2006",.) 
replace hhid0= subinstr(hhid0, "g", "2007",.) 
replace hhid0= subinstr(hhid0, "h", "2008",.) 
replace hhid0= subinstr(hhid0, "i", "2009",.) 
replace hhid0= subinstr(hhid0, "j", "2010",.) 
replace hhid0= subinstr(hhid0, "k", "2011",.) 
replace hhid0= subinstr(hhid0, "l", "2012",.) 
replace hhid0= subinstr(hhid0, "m", "2013",.) 
replace hhid0= subinstr(hhid0, "n", "2014",.) 
replace hhid0= subinstr(hhid0, "o", "2015",.) 
replace hhid0= subinstr(hhid0, "p", "2016",.) 
replace hhid0= subinstr(hhid0, "q", "2017",.) 
replace hhid0= subinstr(hhid0, "r", "2018",.) 
replace hhid0= subinstr(hhid0, "s", "2019",.) 

destring hhid0, replace
xtset xwaveid wave
**********************************************************************
**********************************************************************
******************** 1. SET UP KEY VARIABLES *************************
**********************************************************************
**********************************************************************

//CPI data (2017/18=100; see ABS website, Cat No 6401.0)
// September quarter, All groups, Australia A2325846C, rebased for 2017/18=100
g cpi = 66.53306613 if wave== 1
replace cpi = 68.67067468 if wave==2
replace cpi = 70.45201514 if wave==3
replace cpi = 72.05522155 if wave==4
replace cpi = 74.28189713 if wave==5
replace cpi = 77.22110888 if wave==6
replace cpi = 78.64618125 if wave==7
replace cpi = 82.56513026 if wave==8
replace cpi = 83.54486751 if wave==9
replace cpi = 85.94967713 if wave==10
replace cpi = 88.88888889 if wave==11
replace cpi = 90.67022935 if wave==12
replace cpi = 92.62970385 if wave==13
replace cpi = 94.7673124 if wave==14
replace cpi = 96.19238477 if wave==15
replace cpi = 97.43932309 if wave==16
replace cpi = 99.22066355 if wave==17
replace cpi	= 101.091071  if wave==18
replace cpi	= 102.7833445 if wave==19
replace cpi	= 103.4958807 if wave==20
replace cpi = cpi/100

//time periods
gen crisis = 0
replace crisis=1 if year==2009

*wealth modules
g module = (year == 2002 | year == 2006 | year == 2010 | year == 2014 | year == 2018)

**********************************************************************************************************************************************************************************************
*** Household characteristics ***

//State
	g nsw=0
	replace nsw=1 if hhstate==1
	g vic=0
	replace vic=1 if hhstate==2
	g qld=0
	replace qld=1 if hhstate==3
	g sa=0
	replace sa=1 if hhstate==4
	g wa=0
	replace wa=1 if hhstate==5
	g other=0
	replace other=1 if hhstate>=6

//Age variables
	g age = hgage
	g age2 = age^2
	g agewmax = 1 if hgagemax<30 
	//age categories based on oldest hh member
	replace agewmax = 2 if hgagemax>=30 & hgagemax<50
	replace agewmax = 3 if hgagemax>=50
	tabulate agewmax, generate(agevar)
	g ageg = .
	replace ageg = 1 if 20<age & age<=39
	replace ageg = 2 if 39<age & age<=64
	replace ageg = 3 if 65<age

//HH members
	g kids = tcr04 + tcr514 if tcr04>=0 & tcr514>=0
	g adults = hhadult

//Education
	g educ = 1 if edhigh1>=8 & edhigh1!=. 
	//high school
	replace educ = 2 if edhigh1==5|edhigh1==4 & edhigh1!=. 
	//TAFE
	replace educ = 3 if edhigh1<=3 & edhigh1>=0 & edhigh1!=. 
	//University
	tabulate educ, generate(educvar)
	//Uni grad and above
	g uni = (edhigh1<=4 & edhigh1>=0 & edhigh1!=.)

//Gender and martial status
	g sex = 0 if hgsex>0 & hgsex!=.
	replace sex = 1 if hgsex==1  
	//hgsex: male=1
	g married = 0 if mrcurr>0 & mrcurr!=.
	replace married = 1 if mrcurr==1|mrcurr==2

//Labour force status
	g nilf = 0 if esbrd>0 & esbrd!=. 
	//not in labour force
	replace nilf = 1 if esbrd==3
	g emp = 0 if esbrd>0 & esbrd!=. 
	//employed
	replace emp = 1 if esbrd==1
	g unemp = 0 if esbrd>0 & esbrd!=. 
	//unemployed
	replace unemp = 1 if esbrd==2
	g becunemp = 0 if unemp!=. & L.unemp!=.
	replace becunemp = 1 if unemp==1 & L.unemp==0 
	//become unemployed
	
//Self-employed
	g selfemp = (esempst== 2 | esempst==3)

//Job security
	g losejob=0 if jbmploj!=. & jbmploj!=-1
	replace losejob=1 if jbmploj>0 & jbmploj!=. & jbmploj!=-1 
	//probability losing job more than 0%
	//AB mod all hholds
	g casual = 0 
	//if jbmcnt!=. & jbmcnt!=-1 & emp==1
	replace casual = 1 if jbmcnt==2|jbcasab==1 
	//causal workers

//Housing status
	g homeown = .
	replace homeown = 1 if hstenr==1
	replace homeown = 0 if hstenr>1 & hstenr!=.
	
	g hsa = .
	replace hsa = 1 if hstenr==2
	replace hsa = 2 if hstenr==1 & hsmgpd==2
	replace hsa = 3 if hstenr==1 & hsmgpd==1

//Financial stress
	g lcons = 0
	replace lcons = 1 if fiprbegmin==1|fiprbfhmin==1|fiprbmrmin==1|fiprbpsmin==1|fiprbuhmin==1|fiprbwmmin==1|fiprbwomin==1
	replace lcons = . if fiprbegmin==.|fiprbfhmin==.|fiprbmrmin==.|fiprbpsmin==.|fiprbuhmin==.|fiprbwmmin==.|fiprbwomin==.

//Mortgage characteristics
	g expect = 0 if homeown==1 & hsmgfin>=0 & hsmgfin!=. 
	//when expect loan paid off
	replace expect = hsmgfin- wave-2000 if hsmgfin>=0 & hsmgfin!=. 

	g mortpay = hsmgi if hsmgi>0 & hsmgi!=. 
	//o-o mortgage repayments
	replace mortpay=0 if mortpay==.
	//replace mortpay=mortpay/cpi*100
	
	//modify all hholds
	gen behindnew1=0 
	//if hsmgsch!=. & hsmgsch>0 //behind on mortgage repayments
	replace behindnew1=1 if hsmgsch==2|hsmgsch==3
	//replace behindnew1=0 if hsmgsch==-1 & own==1
	

**********************************************************************************************************************************************************************************************
***** Income ******

//Disposable (regular) income 
	g hincome = hifdip - hifdin 
	drop inc
	g inc = (hincome)/cpi
	
//Gross income
	gen ginc = (hifefp - hifefn)/cpi
	
//Labour income
	gen labourinc = (hiwsfei + (hibifip - hibifin))/cpi
	gen nonlabourinc = ginc - labourinc
	
**********************************************************************************************************************************************************************************************
***** Wealth ******

//Housing assets and equity
	g homedebt = hwhmdti/cpi
	g hp1 = hsvalui/cpi if hsvalui>0 
	//o-o housing assets
	g hequity = hp1 - homedebt if hp1>0 
	//o-o housing equity
	replace hequity = 0 if (hstenr>1 & hstenr!=.)|(hstenur>1 & hstenur!=.)
	g mortgagedebt = hwtpdi/cpi

//Total assets and debt 
	g debt = hwdebti/cpi 
	//all debt
	g assets = hwassei/cpi 
	//all assets
	g opropdebt = hwopdti/cpi if hwopdti!=. 
	//other property debt
	g nworth = assets - debt 
	//total net wealth

//Non-mortgage debts
	g nmdebt = debt - mortgagedebt
	g otdebt   = hwothdi/cpi
	g ccdebt   = hwccdti/cpi
	g hecsdebt = hwhecdi/cpi
	g busdebt = hwbusdi/cpi
	g invdebt = 0
	replace invdebt = dtinvatotal/cpi if dtinvatotal !=. & dtinvatotal >0
	g cardebt = 0 
	replace cardebt = dtcaratotal/cpi if dtcaratotal !=. & dtcaratotal >0
	g perdebt = 0
	replace perdebt = dtoplatotal/cpi if dtoplatotal !=. & dtoplatotal >0
	g hiredebt = 0
	replace hiredebt = dthpatotal/cpi if dthpatotal !=. & dthpatotal >0

//Financial assets
	*g finassets = (hweqini + hwcaini + hwtrusi + hwtbani)/cpi
	g finassets = hwfini/cpi
	g equity = hweqini/cpi
	g cash = hwcaini/cpi
	g trust = hwtrusi/cpi
	g bank =  hwtbani/cpi
	g portrisk = equity/finassets*100

//Hand-to-mouth households
	g liqassets = (hwtbani + hweqini + hwcaini)/cpi 
	//liquid assets

	g liqdebt = hwccdti/cpi 
	//liquid debt

	g liqnworth = liqassets-liqdebt 
	//liquid net wealth
	*g liqnw_adj = liqnworth + buffer 

	g illiqnworth = nworth-liqnworth 
	//illiquid net wealth
	*g illiqnw_adj = illiqnworth-buffer 

	g credit_limit = inc/12 
	//credit limit set to monthly pay (see KWV 2014)
	g pay = inc/26 
	//fornightly pay
	
//HTM hhs according to KVW (2014)
	g htm = 0
	replace htm=1 if (pay/2>=liqnw & liqnworth>=0)
	replace htm=1 if (pay/2-credit_limit>=liqnworth & liqnworth<=0)

//Can raise money
	g canraisefin = (fibfin==1)
	g easyraise = .
	replace easyraise = 0 if fiemerf==3 | fiemerf==4
	replace easyraise = 1 if fiemerf==1 | fiemerf==2
	
//Borrow from a financial institution - only to those who say yes to could raise $2000
	g borrowfin = .
	replace borrowfin = 0 if fibfin==0
	replace borrowfin = 1 if fibfin==1
	
//Saving habit
	g saver = .
	replace saver = 0 if fisave==1 | fisave==2 
	replace saver = 1 if fisave==3 | fisave==4 | fisave==5
	
//Financial risk preferences
	g finriskpref = firiskbar if firiskbar>0
	g finrisk = .
	replace finrisk = 1 if finriskpref<=3
	replace finrisk = 0 if finriskpref==4
	
//Self-ranked prosperity
	g selfrank = 7 - fiprospmin
	
//Financial distress 
	*Could not pay electricity gas or utilities.
	g billproblem = (fiprbegmin == 1)

	g mortproblem = (fiprbmrmin==1)

	g askedhelp = (fiprbfhmin==1) 
	g askedwelfare = (fiprbwomin==1)
	g soldsomething = (fiprbpsmin==1)
	g heathome = (fiprbuhmin==1)
	g withoutmeal = (fiprbwmmin==1)

	g problem = (mortproblem == 1 | billproblem == 1)

	g sfinstress = billprob + mortprob + askedhelp + askedwelfare + soldsomething + heathome + withoutmeal 
	g finstress = (sfinstress > 2)	
	
*******************************************************************************************************************************************************************************************************************************
***** Keep only wealth modules and non-movers ******
	
//Keep only waves with wealth modules
	keep if module == 1 
	
//Set up panel
	xtset xwaveid wave, delta(4)
	
//Keep non-movers: defined as those who never moved out of their SA3
	g moved_l = . 
	replace moved_l = 1 if hhssa3 != l.hhssa3 & l.hhssa3 !=.
	replace moved_l = 0 if hhssa3 == l.hhssa3 & l.hhssa3 !=.
	bysort xwaveid: egen summoved_l = sum(moved_l)
	g nonmovers = . 
	replace nonmovers = 1 if summoved_l == 0
	replace nonmovers = 0 if summoved_l > 0 
	
//Keep only those who exist in 2 consecutive waves
	* select households that report in at least 2 consecutive wealth modules - since they will drop from our analysis anyway
	* ie have at least reported in 2002/2006, 2006/2010 or 2010/2014 or 2014/2018
	gen ind1 = 0
	replace ind1 = 1 if wave==2
	replace ind1 = 10 if wave==6
	replace ind1 = 100 if wave==10
	replace ind1 = 1000 if wave==14
	replace ind1 = 10000 if wave==18
	bysort xwaveid: egen ind2 = total(ind1)

	* single wealth module responsdents
	g exclude = 0
	replace exclude = 1 if ind2==1 | ind2==10 | ind2 == 100 | ind2==1000 | ind2 == 10000
	//drop if ind2==1 | ind2==10 | ind2 == 100 | ind2==1000
	* non-consec wealth modules
	replace exclude = 1 if ind2==101 | ind2==1001 | ind2==1010 | ind2==10100
	//drop if ind2==101 | ind2==1001 | ind2==1010
	drop ind1 ind2

//Keep only non-movers
	replace exclude = 1 if nonmovers == 0
	
//Keep only post-GFC
	replace exclude = 1 if year < 2014
	
//Drop negative hhssa3
	drop if hhssa3 < 0
	
	
*******************************************************************************************************************************************************************************************************************************
***** Lagged and first differencing variables ******

//Demographics and HH structure (Since we follow households, age and sex of household heads could change over time too.)
	g Lage = L.age
	g Lage2 = L.age2
	g Lageg = L.ageg
	g Lsex = L.sex
	g Lmarried = L.married
	g Leduc = L.educ
	g Luni = L.uni
	g Lkids = L.kids
	g Ladults = L.adults
	g Lnilf = L.nilf
	g Lemp = L.emp
	g Lselfemp = L.selfemp
	g Dkids = D.kids
	g Dadults = D.adults
	g Demp = D.emp
	g Deduc = D.educ
	g Dmarried = D.married
	g Dselfemp = D.selfemp
	g Dnilf = D.nilf
	g Duni = D.uni
	
//Income, net worth, and financial assets
	g Lginc = L.ginc
	g Dginc = D.ginc
	g Llabourinc = L.labourinc
	g Dlabourinc = D.labourinc
	//Local Income Ranking
	egen incg = xtile(inc), by(hhssa3 year) nq(4) 
	g Lincgn = L.incg
	g Lselfrank = L.selfrank
	g Lnworth = L.nworth
	g Dnworth = D.nworth
	g Lassets = L.assets
	g Dassets = D.assets
	g Lfinassets = L.finassets
	g Dfinassets = D.finassets
	g Lliqnworth = L.liqnworth
	g Dliqnworth = D.liqnworth
	g Lhsa = L.hsa
	g Lhomeown = L.homeown
	g Dhomeown = D.homeown
	
//Debt accumulation as share of initial income
	foreach i in debt mortgagedebt homedebt opropdebt nmdebt ccdebt cardebt hecsdebt busdebt invdebt perdebt hiredebt{
	g L`i' = L.`i'
	g log`i' = log(`i')
	g `i'toinc = `i'/ginc*100
	g D`i' = D.`i'
	g D`i'toinc = D`i'/Lginc*100
	}
	
//IHS transformation
	foreach x in debt mortgagedebt homedebt opropdebt nmdebt ccdebt cardebt hecsdebt busdebt invdebt perdebt hiredebt{
	g i`x' = log(`x' + sqrt(`x'^2+1))
	g di`x' = d.i`x'
	}
	
//Accumulation of risky financial assets as a share of initial financial portfolio
	g Dportrisk = D.equity/L.finassets*100
	g Dportrisk_a = D.portrisk
	
//Unemployment rate
	g Lurate = L.hhura
	g Durate = D.hhura
	
//Financial situation and preferences
	g Lhtm = L.htm
	g Lfinstress = L.finstress
	g Lcanraisefin = L.canraisefin
	g Lfinrisk = L.finrisk
	g Dfinrisk = D.finrisk
	g Llcons = L.lcons
	g Leasyraise = L.easyraise
	g Lborrowfin = L.borrowfin
	g Lsaver = L.saver


**********************************************************************************************************************************************************************************************
***** Macro variables ******

merge m:1 hhssa3 year using  "inequalitysa3.dta", nogen keep(match master)
merge m:1 hhssa3 year using  "SA3_Housing_Prices.dta", nogen keep(match master)
*CoreLogic housing prices are private data and not to be released

xtset xwaveid wave, delta(4)

//Changes in Gini coefficients
	egen stdgini = std(Ginicoefficient)
	g Dgini = D.stdgini
	
//within vs between variation
	xtsum Ginicoefficient
	g dgini = ((D.Ginicoefficient)/0.017364)
	
//Change in top 10% share of income
	g Dtop10 = D.Top10
	
//Housing prices
	g Lmedhp = L.mediansalespricerolling3months
	g Dmedhp = D.mediansalespricerolling3months
	
//Median measures from HILDA data
	bysort hhssa3 year: egen medinc = median(ginc)
	bysort hhssa3 year: egen meddebt = median(debt)
	bysort hhssa3 year: egen medhomedebt = median(homedebt)
	xtset xwaveid wave, delta(4)
	g Lmedinc = L.medinc
	g Lmeddebt = L.meddebt
	g Lmedhomedebt = L.medhomedebt
	g Dmedinc = D.medinc
	g Dmeddebt = D.meddebt
	g Dmedhomedebt = D.medhomedebt
	

//save file for analytical work
save "UnbalancedHH_analytical.dta", replace

**************************************************************************************************************************************************************************************************
***** SUMMARY STATISTICS ******

use "UnbalancedHH_analytical.dta", clear

* TABLE 1
estpost tabstat age sex married kids uni nilf emp homeown inc nworth finassets debt mortgagedebt homedebt opropdebt nmdebt ccdebt hiredebt cardebt busdebt invdebt [aweight=hhwth] if nonmovers==1 , by(year) s(count mean) columns(statistics) 	

estpost tabstat kids [aweight=hhwth] if nonmovers==1 & kids>0, by(year) s(count mean) columns(statistics)

* TABLE A1
estpost tabstat age sex married kids uni nilf emp homeown inc nworth finassets debt mortgagedebt homedebt opropdebt nmdebt ccdebt hiredebt cardebt busdebt invdebt [aweight=hhwth] if nonmovers==1 , by(year) s(count mean) columns(statistics) 	
estpost tabstat kids [aweight=hhwth] if nonmovers==1 & kids>0, by(year) s(count mean) columns(statistics)

* TABLE A2
estpost tabstat age ageg sex married kids uni nilf emp homeown hsa inc q_inc htm invdebt [aweight=hhwth] if exclude==0 & Linvdebt>0 , s(mean sd count) columns(statistics) 

* FIGURE 3
preserve
egen sa3group = group(hhssa3 year)
bysort sa3group: egen totaldebt_sa3 = sum(debt)
replace totaldebt_sa3=totaldebt_sa3/1000000
collapse (mean) totaldebt_sa3 Ginicoefficient, by(sa3group hhssa3 year)
binscatter totaldebt_sa3 Ginicoefficient, nq(50) xtitle(Gini coefficient) ytitle("Total household debt – {c $|}m") pos(5) ring(0) col(1))
restore
